<?php
/**
 * Mosallas Settings Page Template
 */

if (!defined('ABSPATH')) {
    exit;
}

$api_key = get_option('mosallas_api_key', '');
$api_route = get_option('mosallas_webhook_url', 'https://mosallas.ir/api/wordpress/webhook');
$connection_status = get_option('mosallas_connection_status', 'pending');
$connection_message = get_option('mosallas_connection_message', '');
$connection_error = get_option('mosallas_connection_error', '');
$site_id = get_option('mosallas_site_id', '');

$status_map = array(
    'connected' => array(
        'icon' => '✓',
        'text' => __('اتصال برقرار است', 'mosallas'),
    ),
    'error' => array(
        'icon' => '✗',
        'text' => __('اتصال قطع شده است', 'mosallas'),
    ),
    'pending' => array(
        'icon' => '⏳',
        'text' => __('در انتظار اتصال', 'mosallas'),
    ),
);

$current_status = $status_map[$connection_status] ?? $status_map['pending'];
$status_meta = $connection_message ?: ($connection_error ?: __('برای فعال‌سازی، روی دکمه اتصال کلیک کنید.', 'mosallas'));
$status_class = 'mosallas-status-' . ($connection_status ?: 'pending');
$default_button_label = __('اتصال به وبسایت', 'mosallas');
$loading_button_label = __('در حال اتصال...', 'mosallas');
$last_updated = get_option('mosallas_connection_updated_at');
$status_details = array(
    __('آدرس وبسایت', 'mosallas') => get_site_url(),
    __('نام وبسایت', 'mosallas') => get_bloginfo('name'),
);

if (!empty($site_id)) {
    $status_details[__('شناسه وبسایت Mosallas', 'mosallas')] = esc_html($site_id);
}
?>

<div class="mosallas-admin-wrap">
    <section class="mosallas-header">
        <div class="mosallas-header__inner">
            <div class="mosallas-header__content">
                <span class="mosallas-badge">
                    <span class="mosallas-badge__icon">⚙️</span>
                    <?php esc_html_e('تنظیمات اتصال افزونه Mosallas', 'mosallas'); ?>
                </span>
                <div class="mosallas-brand">
                    <span class="mosallas-logo">Mosallas.ir</span>
                    <span class="mosallas-brand__divider"></span>
                    <span><?php esc_html_e('خودکارسازی محتوا برای وردپرس', 'mosallas'); ?></span>
                </div>
                <h1 class="mosallas-title">
                    <?php esc_html_e('اتصال وبسایت شما به Mosallas.ir', 'mosallas'); ?><br />
                    <span><?php esc_html_e('ایجاد و انتشار مقالات سئو با یک کلیک', 'mosallas'); ?></span>
                </h1>
                <p class="mosallas-subtitle">
                    <?php esc_html_e('برای شروع، کلید API خود را وارد کرده و روی دکمه اتصال کلیک کنید تا ارتباط بین Mosallas.ir و وبسایت وردپرسی شما برقرار شود.', 'mosallas'); ?>
                </p>
                <div class="mosallas-header__actions">
                    <button
                        type="button"
                        class="mosallas-button mosallas-button--primary"
                        id="mosallas-test-connection"
                        data-default-text="<?php echo esc_attr($default_button_label); ?>"
                        data-loading-text="<?php echo esc_attr($loading_button_label); ?>"
                    >
                        <span>🔗</span>
                        <?php echo esc_html($default_button_label); ?>
                    </button>
                    <a
                        class="mosallas-button mosallas-button--ghost"
                        href="https://app.mosallas.ir/dashboard/projects"
                        target="_blank"
                        rel="noopener noreferrer"
                    >
                        <span>🌐</span>
                        <?php esc_html_e('مشاهده داشبورد Mosallas', 'mosallas'); ?>
                    </a>
                </div>
            </div>
            <aside class="mosallas-header__panel">
                <div class="mosallas-status-card">
                    <div class="mosallas-status-card__header"><?php esc_html_e('وضعیت اتصال', 'mosallas'); ?></div>
                    <div class="mosallas-status <?php echo esc_attr($status_class); ?>">
                        <div class="mosallas-status-icon"><?php echo esc_html($current_status['icon']); ?></div>
                        <div class="mosallas-status-body">
                            <div class="mosallas-status-text"><?php echo esc_html($current_status['text']); ?></div>
                            <div class="mosallas-status-meta" data-default-message="<?php echo esc_attr($status_meta); ?>"><?php echo esc_html($status_meta); ?></div>
                        </div>
                    </div>
                    <div class="mosallas-status-details">
                        <?php foreach ($status_details as $label => $value) : ?>
                            <div><strong><?php echo esc_html($label); ?>:</strong> <?php echo esc_html($value); ?></div>
                        <?php endforeach; ?>
                        <?php if (!empty($last_updated)) : ?>
                            <div><strong><?php esc_html_e('آخرین بروزرسانی', 'mosallas'); ?>:</strong> <?php echo esc_html($last_updated); ?></div>
                        <?php endif; ?>
                    </div>
                </div>
            </aside>
        </div>
    </section>

    <section class="mosallas-container">
        <div class="mosallas-split">
            <div class="mosallas-card">
                <div class="mosallas-card-header">
                    <h2><?php esc_html_e('اطلاعات اتصال', 'mosallas'); ?></h2>
                    <p><?php esc_html_e('کلید API و آدرس وب‌هوک را از داشبورد Mosallas دریافت کرده و در اینجا ذخیره کنید.', 'mosallas'); ?></p>
                </div>

                <form method="post" action="" class="mosallas-form">
                    <?php wp_nonce_field('mosallas_settings_action', 'mosallas_settings_nonce'); ?>

                    <div class="mosallas-form-group">
                        <label for="mosallas_api_key"><?php esc_html_e('کلید API', 'mosallas'); ?></label>
                        <div class="mosallas-field-control">
                            <input
                                type="password"
                                class="mosallas-input"
                                id="mosallas_api_key"
                                name="mosallas_api_key"
                                value="<?php echo esc_attr($api_key); ?>"
                                autocomplete="off"
                                placeholder="<?php esc_attr_e('کلید API خود را وارد کنید', 'mosallas'); ?>"
                            />
                            <button type="button" class="mosallas-button mosallas-button--icon" id="mosallas-toggle-api-key" aria-label="<?php esc_attr_e('نمایش یا مخفی کردن کلید API', 'mosallas'); ?>">👁️</button>
                            <button type="button" class="mosallas-button mosallas-button--icon" id="mosallas-copy-api-key" aria-label="<?php esc_attr_e('کپی کردن کلید API', 'mosallas'); ?>">📋</button>
                        </div>
                        <p class="mosallas-field-hint"><?php esc_html_e('از منوی پروژه در داشبورد Mosallas، گزینه «اتصال به وردپرس» را انتخاب کرده و کلید API را کپی کنید.', 'mosallas'); ?></p>
                    </div>

                    <div class="mosallas-form-group">
                        <label for="mosallas_webhook_url"><?php esc_html_e('آدرس API', 'mosallas'); ?></label>
                        <div class="mosallas-field-control">
                            <input
                                type="url"
                                class="mosallas-input"
                                id="mosallas_webhook_url"
                                name="mosallas_webhook_url"
                                value="<?php echo esc_url($api_route); ?>"
                                placeholder="https://mosallas.ir/api/wordpress/webhook"
                            />
                        </div>
                        <p class="mosallas-field-hint"><?php esc_html_e('در اکثر مواقع نیازی به تغییر این آدرس نیست. تنها در صورت دریافت دستور از پشتیبانی، مقدار جدید را وارد کنید.', 'mosallas'); ?></p>
                    </div>

                    <div class="mosallas-form-footer">
                        <?php submit_button(__('ذخیره تنظیمات', 'mosallas'), 'primary mosallas-button mosallas-button--soft', 'mosallas_save_settings', false); ?>
                        <span class="mosallas-form-caption"><?php esc_html_e('پس از ذخیره، روی دکمه «اتصال به وبسایت» کلیک کنید.', 'mosallas'); ?></span>
                    </div>
                </form>
            </div>

            <div class="mosallas-card">
                <div class="mosallas-card-header">
                    <h2><?php esc_html_e('مراحل اتصال', 'mosallas'); ?></h2>
                    <p><?php esc_html_e('با دنبال کردن مراحل زیر، ارتباط بین Mosallas.ir و وبسایت شما برقرار خواهد شد.', 'mosallas'); ?></p>
                </div>
                <ol class="mosallas-steps">
                    <li>
                        <div class="mosallas-step-title"><?php esc_html_e('ورود به داشبورد Mosallas', 'mosallas'); ?></div>
                        <p><?php esc_html_e('به داشبورد Mosallas وارد شده و پروژه خود را انتخاب کنید.', 'mosallas'); ?></p>
                    </li>
                    <li>
                        <div class="mosallas-step-title"><?php esc_html_e('دریافت کلید API', 'mosallas'); ?></div>
                        <p><?php esc_html_e('از بخش «اتصال به وردپرس»، کلید API و آدرس وب‌هوک اختصاصی خود را کپی کنید.', 'mosallas'); ?></p>
                    </li>
                    <li>
                        <div class="mosallas-step-title"><?php esc_html_e('ذخیره تنظیمات و اتصال', 'mosallas'); ?></div>
                        <p><?php esc_html_e('کلید را در فرم بالا ذخیره کرده و سپس روی دکمه «اتصال به وبسایت» کلیک کنید تا ارتباط تایید شود.', 'mosallas'); ?></p>
                    </li>
                </ol>
            </div>

            <div class="mosallas-card mosallas-features">
                <div class="mosallas-card-header">
                    <h2><?php esc_html_e('مزایای اتصال فعال', 'mosallas'); ?></h2>
                    <p><?php esc_html_e('پس از برقراری اتصال، قابلیت‌های زیر به صورت خودکار فعال خواهند شد.', 'mosallas'); ?></p>
                </div>
                <div class="mosallas-features-grid">
                    <div class="mosallas-feature">
                        <span class="mosallas-feature-icon">📝</span>
                        <h3><?php esc_html_e('انتشار خودکار مقالات', 'mosallas'); ?></h3>
                        <p><?php esc_html_e('محتوای تولید شده در Mosallas مستقیما در وبسایت شما منتشر می‌شود.', 'mosallas'); ?></p>
                    </div>
                    <div class="mosallas-feature">
                        <span class="mosallas-feature-icon">🔗</span>
                        <h3><?php esc_html_e('لینک‌سازی داخلی هوشمند', 'mosallas'); ?></h3>
                        <p><?php esc_html_e('پیوندهای داخلی بر اساس محتوا و استراتژی سئوی شما ایجاد می‌شوند.', 'mosallas'); ?></p>
                    </div>
                    <div class="mosallas-feature">
                        <span class="mosallas-feature-icon">📊</span>
                        <h3><?php esc_html_e('گزارش‌گیری و لاگ‌ها', 'mosallas'); ?></h3>
                        <p><?php esc_html_e('از طریق این افزونه، وضعیت هر انتشار و خطای احتمالی را بررسی کنید.', 'mosallas'); ?></p>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>
